#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "bin_ops.h"

/*
 * sub optimal way of reading a le32 bit int.
 */
uint32_t read_32(uint8_t *buf)
{
	uint32_t ret, b0, b1, b2, b3;
	
	b0 = buf[0];
	b1 = buf[1];
	b2 = buf[2];
	b3 = buf[3];

/*	printf("%d %d %d %d\n", b0, b1, b2, b3);*/

	b1 = b1 << 8;
	b2 = b2 << 16;
	b3 = b3 << 24;
	
/*	printf("%d %d %d %d\n", b0, b1, b2, b3);*/

	ret = b0 + b1 + b2 + b3;

/*	printf("ret: %d\n", ret);*/

	return(ret);
}

/*
 * sub optimal way of reading a le32 bit int.
 */
uint32_t read_32_be(uint8_t *buf)
{
	uint32_t ret, b0, b1, b2, b3;
	
	b3 = buf[0];
	b2 = buf[1];
	b1 = buf[2];
	b0 = buf[3];

/*	printf("%d %d %d %d\n", b0, b1, b2, b3);*/

	b1 = b1 << 8;
	b2 = b2 << 16;
	b3 = b3 << 24;
	
/*	printf("%d %d %d %d\n", b0, b1, b2, b3);*/

	ret = b0 + b1 + b2 + b3;

/*	printf("ret: %d\n", ret);*/

	return(ret);
}

/*
 * sub optimal way of reading a be16 bit int.
 */
uint16_t read_16_be(uint8_t *buf)
{
	uint16_t ret, b0, b1;
	
	b1 = buf[0];
	b0 = buf[1];

/*	printf("%d %d %d %d\n", b0, b1, b2, b3);*/

	b1 = b1 << 8;
	
/*	printf("%d %d %d %d\n", b0, b1, b2, b3);*/

	ret = b0 + b1;

/*	printf("ret: %d\n", ret);*/

	return(ret);
}

/*
 * check that there is a 4 byte header here.
 */ 
int check_header(uint8_t *buf, char *header)
{
		if (memcmp(buf, header, 4) == 0)
			return 1;
		else
			return 0;
}
